************************************************************************************************
* Name			: table 3 - balance tests for the instrumental variables 
*
* Description	: This dofile performs regressions of the instrumental variables on baseline 
* 				  characteristics of the mother and of the town.  	
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 



******************************************************************************* 
* REGRESSIONS 
******************************************************************************* 

* Create a factor score for mother's cognition 
factor edu_yrs_mo0_st raventot_st peabody_mo1_st adult_books0 adult_mags0, ipf factor(1) 
predict fcogmo 

* Create a factor score for mother's socio-emotional 
factor cesdD0_st cesdA0_st cesdB0_st cesdE0_st cesdF0_st cesdG0_st cesdH0_st cesdI0_st  cesdJ0_st, ipf factor(1) 
predict fncogmo



foreach instrument in meanprice_juglibros_log FUmeanprice_log tpobc_pop1993{

local append "append" 
if "`instrument'"=="meanprice_juglibros_log" local append "replace" 

reg `instrument' fcogmo fncogmo married0 wealth_index0 period_terrorism2, cl(cod_dane)  
test fcogmo fncogmo married0 wealth_index0 period_terrorism2
local Fstat = r(F)
local Fpval = r(p)
outreg2 using "$dir_output/Table3.xls", excel noaster dec(3) `append' addstat(Fstat, `Fstat', Fpval, `Fpval') 

} 
